/**
 * Coverflow
 * http://BarryCarlyon.co.uk/
 *
 * Copyright (c) 2010 Barry Carlyon
 * MIT License
 *
 * Built on top of the jQuery library
 *   http://jquery.com
 *
 * Requires jCarousel
 * Requires jQuery UI
 *
 */

(function($) {
	var thecarousel;
	var theslider;
	var titlebox;
	var items;
	var options;

	$.coverflow = function(settings) {
		var defaults = {
			total_items	: 0,
			slider_start	: 0,

			targetflow	: 'coverflow',
			sliderflow	: 'slider',
			titleflow	: 'coverflow_title',
			largesize	: 200,
			smallsize	: 50,

			speed		: 3000,

			scroll		: 1,
			visible		: 3,
			animation	: 0
		};

		options = $.extend({}, defaults, settings || {});

		options.marginsize = (options.largesize - options.smallsize) / 2;
		if (!options.animation) {
			options.animation = options.speed;
		}

		// add extra buffer itmes to start and end of items
		// do before carousel as carusel alters the dom
//		var buffer = Math.round((options.visible - 1) / 2);
		var buffer = Math.ceil((options.visible - 1) / 2);
		if (!buffer) {
			buffer = 1;
		}

		var itemspre = document.getElementById(options.targetflow);
		for (x = 0; x < buffer; x++) {
			var bufferelement = document.createElement('li');
			bufferelement.innerHTML = "&nbsp;";
			itemspre.insertBefore(bufferelement, itemspre.firstChild);
			var bufferelement = document.createElement('li');
			bufferelement.innerHTML = "&nbsp;";
			itemspre.appendChild(bufferelement);
		}

		// setup the carousel
		// requires jcarousel
		$('#' + options.targetflow).jcarousel({
			scroll		: options.scroll,
			visible		: options.visible,
			animation	: options.animation,
			auto		: 0,

			initCallback	: function(carousel) {
				thecarousel = carousel;
				collapse(options);
			},
			itemFirstInCallback: {
				onBeforeAnimation: flow
			},
		});

		// generate common
		items = thecarousel.list.context.children;
		titlebox = document.getElementById(options.titleflow);
		

		// check for total items
		if (!options.total_items) {
			// get total items from the carousel
			options.total_items = items.length;
		}
		if (options.slider_start == 'rnd') {
//			options.slider_start = Math.round(Math.random(options.total_items)) + 1;
			options.slider_start = Math.floor(Math.random() * options.total_items + 1);
		}
		if (!options.slider_start) {
			// start in the middle
			options.slider_start = Math.round(options.total_items / 2);
		}

		// quick bit of speed math
		options.onespeed	= options.speed / 3;
		options.twospeed	= options.onespeed * 2;
		options.onehalfspeed	= options.onespeed * 1.5

		// slider setup
		// requires slider from ui
		theslider = $('#' + options.sliderflow).slider({
			'min'		: 0,
			'max'		: options.total_items,
			'value'		: options.slider_start,
			'start'		: function(event, ui) {
				collapse(options);
			},
			'change'	: function(event, ui) {
				thecarousel.scroll(ui.value);
				theslider.slider('disable');
				setTimeout(function() { theslider.slider('enable') }, options.speed);
			},
		});

		thecarousel.scroll(theslider.slider('value'));
	}
//	$.fn.coverflow = function(settings) {
//	}

	function collapse() {
		$('#' + options.targetflow + ' img').animate({
			width		: options.smallsize + 'px',
			height		: options.smallsize + 'px',
			marginLeft	: options.marginsize + 'px',
			marginTop	: options.marginsize + 'px',
		}, options.speed);
	}
	function grow(item) {
		$(item).animate({
			width		: options.largesize + 'px',
			height		: options.largesize + 'px',
			marginLeft	: '0px',
			marginTop	: '0px',
		}, options.speed);
	}

	function flow(carousel, theli, theindex, action) {
		if (action != 'init') {
			var this_a = items[theindex].getElementsByTagName('a')[0];
			var this_i = items[theindex].getElementsByTagName('img')[0];

			grow(this_i);
			var titlestring = '<a href="' + this_a.href + '">' + this_i.title + '</a>';
			$(titlebox).fadeOut(options.onespeed).delay(options.twospeed).fadeIn(options.onespeed);
			setTimeout(function() { titlebox.innerHTML = titlestring }, options.onehalfspeed);
		}
	}
})(jQuery);
